/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public final class ObjectMappers {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private static AtomicReference<ObjectMapper> SYNAPSE_OBJECT_MAPPER;

    public static ObjectMapper defaultObjectMapper() {
        return DEFAULT_OBJECT_MAPPER;
    }

    public static ObjectMapper currentObjectMapper() {
        return SYNAPSE_OBJECT_MAPPER.get();
    }

    public static synchronized void overrideObjectMapper(ObjectMapper objectMapper) {
        SYNAPSE_OBJECT_MAPPER.set(Objects.requireNonNull(objectMapper));
    }

    private ObjectMappers() {
    }

    static {
        DEFAULT_OBJECT_MAPPER.findAndRegisterModules();
        DEFAULT_OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        DEFAULT_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        DEFAULT_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE);
        SYNAPSE_OBJECT_MAPPER = new AtomicReference<ObjectMapper>(DEFAULT_OBJECT_MAPPER);
    }
}

