/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation;

import com.google.common.base.Strings;
import de.otto.synapse.annotation.BeanNameHelper;
import de.otto.synapse.annotation.EnableEventSource;
import de.otto.synapse.annotation.EnableEventSources;
import de.otto.synapse.eventsource.DelegateEventSource;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.MultiValueMap;

public class EventSourceBeanRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceBeanRegistrar.class);
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        MultiValueMap eventSourcesAttr = metadata.getAllAnnotationAttributes(EnableEventSources.class.getName(), false);
        if (eventSourcesAttr != null) {
            Object value = eventSourcesAttr.getFirst((Object)"value");
            this.registerMultipleEventSources(registry, (AnnotationAttributes[])value);
        } else {
            MultiValueMap eventSourceAttr = metadata.getAllAnnotationAttributes(EnableEventSource.class.getName(), false);
            this.registerSingleEventSource(registry, (MultiValueMap<String, Object>)eventSourceAttr);
        }
    }

    private void registerMultipleEventSources(BeanDefinitionRegistry registry, AnnotationAttributes[] annotationAttributesArr) {
        for (AnnotationAttributes annotationAttributes : annotationAttributesArr) {
            String streamName = this.environment.resolvePlaceholders(annotationAttributes.getString("streamName"));
            String beanName = Objects.toString(Strings.emptyToNull((String)annotationAttributes.getString("name")), BeanNameHelper.beanNameForStream(streamName));
            String builderName = annotationAttributes.getString("builder");
            if (registry.containsBeanDefinition(beanName)) {
                throw new BeanCreationException(beanName, String.format("EventSource %s is already registered.", beanName));
            }
            this.registerBeanDefinition(registry, beanName, streamName.isEmpty() ? beanName : streamName, builderName);
        }
    }

    private void registerSingleEventSource(BeanDefinitionRegistry registry, MultiValueMap<String, Object> eventSourceAttr) {
        if (eventSourceAttr != null) {
            String streamName = this.environment.resolvePlaceholders(eventSourceAttr.getFirst((Object)"streamName").toString());
            String beanName = Objects.toString(Strings.emptyToNull((String)eventSourceAttr.getFirst((Object)"name").toString()), BeanNameHelper.beanNameForStream(streamName));
            String builderName = eventSourceAttr.getFirst((Object)"builder").toString();
            if (!registry.containsBeanDefinition(beanName)) {
                this.registerBeanDefinition(registry, beanName, streamName.isEmpty() ? beanName : streamName, builderName);
            } else {
                throw new BeanCreationException(beanName, String.format("EventSource %s is already registered.", beanName));
            }
        }
    }

    private void registerBeanDefinition(BeanDefinitionRegistry registry, String beanName, String streamName, String builderName) {
        registry.registerBeanDefinition(beanName, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DelegateEventSource.class).addConstructorArgValue((Object)beanName).addConstructorArgValue((Object)streamName).addConstructorArgValue((Object)builderName).setDependencyCheck(3).setAutowireMode(1).getBeanDefinition());
        LOG.info("Registered EventSource {} with for streamName {} using {}", new Object[]{beanName, streamName, builderName});
    }
}

