/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ChannelPosition {
    private final Map<String, String> shardPositions;

    protected ChannelPosition(Map<String, String> shardPositions) {
        this.shardPositions = shardPositions;
    }

    public static ChannelPosition fromHorizon() {
        return ChannelPosition.of(Collections.emptyMap());
    }

    public static ChannelPosition merge(List<ChannelPosition> channelPositions) {
        LinkedHashMap<String, String> shardPositions = new LinkedHashMap<String, String>();
        channelPositions.forEach(streamPosition -> streamPosition.shards().forEach(shardId -> shardPositions.put((String)shardId, streamPosition.positionOf((String)shardId))));
        return new ChannelPosition(shardPositions);
    }

    public static ChannelPosition of(String shardId, String position) {
        return ChannelPosition.of(Collections.singletonMap(shardId, position));
    }

    public static ChannelPosition of(Map<String, String> shardPositions) {
        return new ChannelPosition(shardPositions);
    }

    public Set<String> shards() {
        return this.shardPositions.keySet();
    }

    public String positionOf(String shard) {
        return this.shardPositions.getOrDefault(shard, "0");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelPosition that = (ChannelPosition)o;
        return Objects.equals(this.shardPositions, that.shardPositions);
    }

    public int hashCode() {
        return Objects.hash(this.shardPositions);
    }

    public String toString() {
        return "StreamPosition{shardPositions=" + this.shardPositions + '}';
    }
}

