/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchingMessageConsumer
implements MessageConsumer<String> {
    private static final Logger LOG = LoggerFactory.getLogger(DispatchingMessageConsumer.class);
    private static final Pattern ACCEPT_ALL = Pattern.compile(".*");
    private final List<MessageConsumer<?>> messageConsumers;
    private final ObjectMapper objectMapper;

    public DispatchingMessageConsumer(ObjectMapper objectMapper) {
        this.messageConsumers = Collections.synchronizedList(new ArrayList());
        this.objectMapper = objectMapper;
    }

    public DispatchingMessageConsumer(ObjectMapper objectMapper, List<MessageConsumer<?>> messageConsumers) {
        this.messageConsumers = Collections.synchronizedList(new ArrayList(messageConsumers));
        this.objectMapper = objectMapper;
    }

    public void add(MessageConsumer<?> messageConsumer) {
        this.messageConsumers.add(messageConsumer);
    }

    public List<MessageConsumer<?>> getAll() {
        return Collections.unmodifiableList(this.messageConsumers);
    }

    @Override
    @Nonnull
    public Class<String> payloadType() {
        return String.class;
    }

    @Override
    @Nonnull
    public Pattern keyPattern() {
        return ACCEPT_ALL;
    }

    @Override
    public void accept(Message<String> message) {
        this.messageConsumers.stream().filter(consumer -> this.matchesKeyPattern(message, consumer.keyPattern())).forEach(consumer -> {
            try {
                Class payloadType = consumer.payloadType();
                if (payloadType.equals(String.class)) {
                    consumer.accept(message);
                } else {
                    Object payload = null;
                    if (message.getPayload() != null) {
                        payload = this.objectMapper.readValue((String)message.getPayload(), payloadType);
                    }
                    Message<Object> tMessage = Message.message(message.getKey(), message.getHeader(), payload);
                    consumer.accept(tMessage);
                }
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    private boolean matchesKeyPattern(Message<String> message, Pattern keyPattern) {
        return keyPattern.matcher(message.getKey()).matches();
    }
}

