/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.channel.ChannelPosition;
import java.util.Objects;

public class EventSourceNotification {
    private String eventSourceName;
    private ChannelPosition channelPosition;
    private String streamName;
    private Status status;
    private String message;

    private EventSourceNotification(Builder builder) {
        this.eventSourceName = builder.eventSourceName;
        this.channelPosition = builder.channelPosition;
        this.streamName = builder.streamName;
        this.status = builder.status;
        this.message = builder.message;
    }

    public String getEventSourceName() {
        return this.eventSourceName;
    }

    public ChannelPosition getChannelPosition() {
        return this.channelPosition;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSourceNotification that = (EventSourceNotification)o;
        return Objects.equals(this.eventSourceName, that.eventSourceName) && Objects.equals(this.channelPosition, that.channelPosition) && Objects.equals(this.streamName, that.streamName) && this.status == that.status && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventSourceName, this.channelPosition, this.streamName, this.status, this.message});
    }

    public String toString() {
        return "EventSourceNotification{eventSourceName='" + this.eventSourceName + '\'' + ", streamPosition=" + this.channelPosition + ", streamName='" + this.streamName + '\'' + ", status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventSourceNotification copy) {
        Builder builder = new Builder();
        builder.channelPosition = copy.getChannelPosition();
        builder.streamName = copy.getStreamName();
        builder.status = copy.getStatus();
        return builder;
    }

    public static final class Builder {
        private String eventSourceName;
        private ChannelPosition channelPosition;
        private String streamName;
        private Status status;
        private String message;

        private Builder() {
        }

        public Builder withEventSourceName(String val) {
            this.eventSourceName = val;
            return this;
        }

        public Builder withStreamPosition(ChannelPosition val) {
            this.channelPosition = val;
            return this;
        }

        public Builder withStreamName(String val) {
            this.streamName = val;
            return this;
        }

        public Builder withStatus(Status val) {
            this.status = val;
            return this;
        }

        public Builder withMessage(String msg) {
            this.message = msg;
            return this;
        }

        public EventSourceNotification build() {
            return new EventSourceNotification(this);
        }
    }

    public static enum Status {
        STARTED,
        FAILED,
        FINISHED;

    }
}

