/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.consumer.DispatchingMessageConsumer;
import de.otto.synapse.consumer.EventSourceNotification;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.eventsource.EventSource;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractEventSource
implements EventSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventSource.class);
    private final String name;
    private final ApplicationEventPublisher eventPublisher;
    private final DispatchingMessageConsumer dispatchingMessageConsumer;
    private final AtomicBoolean stopping = new AtomicBoolean(false);

    public AbstractEventSource(String name, ApplicationEventPublisher eventPublisher, ObjectMapper objectMapper) {
        this.name = name;
        this.eventPublisher = eventPublisher;
        this.dispatchingMessageConsumer = new DispatchingMessageConsumer(objectMapper);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void stop() {
        LOG.info("Stopping EventSource {}", (Object)this.name);
        this.stopping.set(true);
    }

    @Override
    public boolean isStopping() {
        return this.stopping.get();
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.dispatchingMessageConsumer.add(messageConsumer);
    }

    @Override
    public DispatchingMessageConsumer dispatchingMessageConsumer() {
        return this.dispatchingMessageConsumer;
    }

    protected void publishEvent(ChannelPosition channelPosition, EventSourceNotification.Status status) {
        this.publishEvent(channelPosition, status, "");
    }

    protected void publishEvent(ChannelPosition channelPosition, EventSourceNotification.Status status, String message) {
        if (this.eventPublisher != null) {
            EventSourceNotification notification = EventSourceNotification.builder().withEventSourceName(this.name).withStreamName(this.getStreamName()).withStreamPosition(channelPosition).withStatus(status).withMessage(message).build();
            try {
                this.eventPublisher.publishEvent((Object)notification);
            }
            catch (Exception e) {
                LOG.error("error publishing event source notification: {}", (Object)notification, (Object)e);
            }
        }
    }
}

