/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import de.otto.synapse.channel.ChannelPosition;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Header {
    private final ChannelPosition channelPosition;
    private final Instant arrivalTimestamp;
    private final Duration durationBehind;

    public static Header emptyHeader() {
        return new Header(null, Instant.now(), null);
    }

    public static Header responseHeader(ChannelPosition channelPosition, Instant arrivalTimestamp, Duration durationBehind) {
        return new Header(channelPosition, arrivalTimestamp, durationBehind);
    }

    public static Header responseHeader(ChannelPosition channelPosition, Instant arrivalTimestamp) {
        return new Header(channelPosition, arrivalTimestamp, null);
    }

    private Header(ChannelPosition channelPosition, Instant approximateArrivalTimestamp, Duration durationBehind) {
        this.channelPosition = channelPosition;
        this.arrivalTimestamp = Objects.requireNonNull(approximateArrivalTimestamp);
        this.durationBehind = durationBehind;
    }

    @Nonnull
    public Optional<ChannelPosition> getChannelPosition() {
        return Optional.ofNullable(this.channelPosition);
    }

    @Nonnull
    public Instant getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    @Nonnull
    public Optional<Duration> getDurationBehind() {
        return Optional.ofNullable(this.durationBehind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.channelPosition, header.channelPosition) && Objects.equals(this.arrivalTimestamp, header.arrivalTimestamp) && Objects.equals(this.durationBehind, header.durationBehind);
    }

    public int hashCode() {
        return Objects.hash(this.channelPosition, this.arrivalTimestamp, this.durationBehind);
    }

    public String toString() {
        return "Header{channelPosition='" + this.channelPosition + '\'' + ", arrivalTimestamp=" + this.arrivalTimestamp + ", durationBehind=" + this.durationBehind + '}';
    }
}

