/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import de.otto.synapse.message.Header;
import de.otto.synapse.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ByteBufferMessage
extends Message<ByteBuffer> {
    public static ByteBufferMessage byteBufferMessage(@Nonnull String key, @Nullable ByteBuffer payload) {
        return new ByteBufferMessage(key, Header.emptyHeader(), payload);
    }

    public static ByteBufferMessage byteBufferMessage(@Nonnull String key, @Nonnull Header header, @Nullable ByteBuffer payload) {
        return new ByteBufferMessage(key, header, payload);
    }

    public static ByteBufferMessage byteBufferMessage(@Nonnull String key, @Nullable String payload) {
        ByteBuffer byteBuffer = payload != null ? ByteBuffer.wrap(payload.getBytes(StandardCharsets.UTF_8)) : null;
        return new ByteBufferMessage(key, Header.emptyHeader(), byteBuffer);
    }

    public static ByteBufferMessage byteBufferMessage(@Nonnull String key, @Nonnull Header header, @Nullable String payload) {
        ByteBuffer byteBuffer = payload != null ? ByteBuffer.wrap(payload.getBytes(StandardCharsets.UTF_8)) : null;
        return new ByteBufferMessage(key, header, byteBuffer);
    }

    private ByteBufferMessage(@Nonnull String key, @Nonnull Header header, @Nullable ByteBuffer payload) {
        super(key, header, payload);
    }
}

