/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.state;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.state.ChronicleMapBytesMarshaller;
import de.otto.synapse.state.StateRepository;
import java.util.Optional;
import net.openhft.chronicle.hash.ChronicleHashClosedException;
import net.openhft.chronicle.map.ChronicleMapBuilder;

public class ChronicleMapStateRepository<V>
extends StateRepository<V> {
    private static final int DEFAULT_KEY_SIZE_BYTES = 128;
    private static final double DEFAULT_VALUE_SIZE_BYTES = 512.0;
    private static final long DEFAULT_ENTRY_COUNT = 100000L;

    private ChronicleMapStateRepository(Builder builder) {
        super(builder.chronicleMapBuilder.create());
    }

    @Override
    public V put(String key, V value) {
        V result = null;
        try {
            result = super.put(key, value);
        }
        catch (ChronicleHashClosedException chronicleHashClosedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Optional<V> get(String key) {
        Optional<Object> result = Optional.empty();
        try {
            result = super.get(key);
        }
        catch (ChronicleHashClosedException chronicleHashClosedException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public long size() {
        try {
            return super.size();
        }
        catch (ChronicleHashClosedException ignore) {
            return 0L;
        }
    }

    public static <V> Builder chronicleMapConcurrentMapStateRepositoryBuilder(Class<V> clazz) {
        return new Builder(clazz);
    }

    public static final class Builder<V> {
        private ObjectMapper objectMapper;
        private final Class<V> clazz;
        private ChronicleMapBuilder<String, V> chronicleMapBuilder;

        private Builder(Class<V> clazz) {
            this.clazz = clazz;
        }

        public Builder<V> withObjectMapper(ObjectMapper val) {
            this.objectMapper = val;
            return this;
        }

        public Builder<V> withMapBuilder(ChronicleMapBuilder<String, V> val) {
            this.chronicleMapBuilder = val;
            return this;
        }

        public ChronicleMapStateRepository build() {
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper();
            }
            if (this.chronicleMapBuilder == null) {
                this.chronicleMapBuilder = ChronicleMapBuilder.of(String.class, this.clazz).averageKeySize(128.0).averageValueSize(512.0).entries(100000L);
            }
            this.chronicleMapBuilder.valueMarshaller(new ChronicleMapBytesMarshaller<V>(this.objectMapper, this.clazz));
            return new ChronicleMapStateRepository(this);
        }
    }
}

