/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.Status;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ChannelResponse {
    private final Status status;
    private final ChannelPosition channelPosition;

    private ChannelResponse(Status status, ChannelPosition channelPosition) {
        this.status = status;
        this.channelPosition = channelPosition;
    }

    public static ChannelResponse of(Status status, ChannelPosition channelPosition) {
        return new ChannelResponse(status, channelPosition);
    }

    public static ChannelResponse of(List<ChannelResponse> channelResponse) {
        boolean stopped = channelResponse.stream().anyMatch(streamResponse -> streamResponse.getStatus() == Status.STOPPED);
        List<ChannelPosition> channelPositions = channelResponse.stream().map(ChannelResponse::getChannelPosition).collect(Collectors.toList());
        return ChannelResponse.of(stopped ? Status.STOPPED : Status.OK, ChannelPosition.merge(channelPositions));
    }

    public Status getStatus() {
        return this.status;
    }

    public ChannelPosition getChannelPosition() {
        return this.channelPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelResponse that = (ChannelResponse)o;
        return this.status == that.status && Objects.equals(this.channelPosition, that.channelPosition);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.channelPosition});
    }

    public String toString() {
        return "StreamResponse{status=" + (Object)((Object)this.status) + ", streamPosition=" + this.channelPosition + '}';
    }
}

