/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import de.otto.synapse.channel.StartFrom;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ShardPosition
implements Serializable {
    private final String shardName;
    private final String position;
    private final StartFrom startFrom;

    private ShardPosition(@Nonnull String shardName, @Nonnull String position) {
        this.shardName = Objects.requireNonNull(shardName);
        this.position = Objects.requireNonNull(position);
        this.startFrom = StartFrom.POSITION;
    }

    private ShardPosition(@Nonnull String shardName) {
        this.shardName = Objects.requireNonNull(shardName);
        this.position = "";
        this.startFrom = StartFrom.HORIZON;
    }

    @Nonnull
    public static ShardPosition fromHorizon(@Nonnull String shardName) {
        return new ShardPosition(shardName);
    }

    @Nonnull
    public static ShardPosition fromPosition(@Nonnull String shardName, @Nonnull String position) {
        return new ShardPosition(shardName, position);
    }

    public String shardName() {
        return this.shardName;
    }

    @Nonnull
    public String position() {
        return this.position;
    }

    @Nonnull
    public StartFrom startFrom() {
        return this.startFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardPosition that = (ShardPosition)o;
        return Objects.equals(this.shardName, that.shardName) && Objects.equals(this.position, that.position) && this.startFrom == that.startFrom;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shardName, this.position, this.startFrom});
    }

    public String toString() {
        return "ShardPosition{shardName='" + this.shardName + '\'' + ", position='" + this.position + '\'' + ", startFrom=" + (Object)((Object)this.startFrom) + '}';
    }
}

