/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.message.Message;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class InterceptorChain
implements MessageInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptorChain.class);
    private final List<MessageInterceptor> interceptors = new CopyOnWriteArrayList<MessageInterceptor>();

    public void register(MessageInterceptor messageInterceptor) {
        this.interceptors.add(messageInterceptor);
    }

    @Override
    @Nullable
    public Message<String> intercept(Message<String> message) {
        LOG.debug("Intercepting message '{}' using {} interceptors", message, (Object)this.interceptors.size());
        Message<String> m = message;
        for (MessageInterceptor interceptor : this.interceptors) {
            if (m != null) {
                m = interceptor.intercept(m);
                continue;
            }
            LOG.debug("Interceptor returned <null> - dropping message");
        }
        return m;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterceptorChain chain = (InterceptorChain)o;
        return Objects.equals(this.interceptors, chain.interceptors);
    }

    public int hashCode() {
        return Objects.hash(this.interceptors);
    }
}

