/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.MessageStore;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CompactingInMemoryMessageStore
implements MessageStore {
    private final ConcurrentNavigableMap<String, Message<String>> messages = new ConcurrentSkipListMap<String, Message<String>>();
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());
    private final boolean removeNullPayloadMessages;

    public CompactingInMemoryMessageStore() {
        this.removeNullPayloadMessages = true;
    }

    public CompactingInMemoryMessageStore(boolean removeNullPayloadMessages) {
        this.removeNullPayloadMessages = removeNullPayloadMessages;
    }

    @Override
    public void add(Message<String> message) {
        String messageKey = message.getHeader().getShardPosition().map(pos -> pos.shardName() + "-" + message.getKey()).orElse(message.getKey());
        if (message.getPayload() == null && this.removeNullPayloadMessages) {
            this.messages.remove(messageKey);
        } else {
            this.messages.put(messageKey, message);
        }
        this.latestChannelPosition.updateAndGet(previous -> message.getHeader().getShardPosition().map(shardPosition -> ChannelPosition.merge(previous, shardPosition)).orElse((ChannelPosition)previous));
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        return this.latestChannelPosition.get();
    }

    @Override
    public Stream<Message<String>> stream() {
        return this.messages.entrySet().stream().map(Map.Entry::getValue);
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

