/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.endpoint.AbstractMessageEndpoint;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageTranslator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class AbstractMessageSenderEndpoint
extends AbstractMessageEndpoint
implements MessageSenderEndpoint {
    private final MessageTranslator<String> messageTranslator;

    public AbstractMessageSenderEndpoint(String channelName, MessageTranslator<String> messageTranslator) {
        super(channelName);
        this.messageTranslator = messageTranslator;
    }

    @Override
    public final <T> void send(@Nonnull Message<T> message) {
        Message<String> translatedMessage = this.messageTranslator.translate(message);
        Message<String> interceptedMessage = this.intercept(translatedMessage);
        if (interceptedMessage != null) {
            this.doSend(interceptedMessage);
        }
    }

    @Override
    public final <T> void sendBatch(@Nonnull Stream<Message<T>> batch) {
        this.doSendBatch(batch.map(this.messageTranslator::translate).map(this::intercept).filter(Objects::nonNull));
    }

    @Override
    @Nonnull
    public final EndpointType getEndpointType() {
        return EndpointType.SENDER;
    }

    protected void doSendBatch(@Nonnull Stream<Message<String>> batch) {
        batch.forEach(this::doSend);
    }

    protected abstract void doSend(@Nonnull Message<String> var1);
}

