/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.eventsource.EventSource;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class EventSourceConsumerProcess
implements SmartLifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(EventSourceConsumerProcess.class);
    private static final String THREAD_NAME_PREFIX = "synapse-consumer-";
    private final List<EventSource> eventSources;
    private volatile ExecutorService executorService;
    private volatile boolean running = false;

    public EventSourceConsumerProcess(List<EventSource> eventSources) {
        this.eventSources = eventSources;
    }

    @EventListener
    public void handleContextRefresh(ContextRefreshedEvent event) {
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public int getPhase() {
        return 0;
    }

    public void start() {
        int eventSourceCount;
        int n = eventSourceCount = this.eventSources != null ? this.eventSources.size() : 0;
        if (eventSourceCount > 0) {
            LOG.info("Initializing EventSourceConsumerProcess with {} EventSources", (Object)eventSourceCount);
            this.running = true;
            CustomizableThreadFactory threadFactory = new CustomizableThreadFactory(THREAD_NAME_PREFIX);
            this.executorService = Executors.newFixedThreadPool(eventSourceCount, (ThreadFactory)threadFactory);
            this.eventSources.forEach(eventSource -> this.executorService.submit(() -> {
                try {
                    LOG.info("Starting {}...", (Object)eventSource.getChannelName());
                    eventSource.consume();
                }
                catch (Exception e) {
                    LOG.error("Starting failed: " + e.getMessage(), (Throwable)e);
                    this.stop();
                }
            }));
        } else {
            LOG.warn("Did not find any EventSource instances to execute");
            this.executorService = null;
            this.running = false;
        }
    }

    public void stop() {
        LOG.info("Shutting down...");
        if (this.executorService != null) {
            try {
                this.eventSources.forEach(EventSource::stop);
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.running = false;
        LOG.info("...done.");
    }

    public boolean isRunning() {
        return this.running;
    }
}

