/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ChannelDurationBehind
implements Serializable {
    private static final Duration MAX_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    public static final Duration UNKNOWN_DURATION_BEHIND = Duration.ofMillis(Long.MAX_VALUE);
    private final ImmutableMap<String, Duration> shardDurationBehind;

    private ChannelDurationBehind() {
        this.shardDurationBehind = ImmutableMap.of();
    }

    private ChannelDurationBehind(@Nonnull Builder builder) {
        this.shardDurationBehind = ImmutableMap.copyOf((Map)builder.shards);
    }

    public static ChannelDurationBehind unknown() {
        return new ChannelDurationBehind();
    }

    public static ChannelDurationBehind unknown(@Nonnull List<String> shardNames) {
        return ChannelDurationBehind.channelDurationBehind().withAll(shardNames.stream().collect(Collectors.toMap(Function.identity(), Functions.constant((Object)UNKNOWN_DURATION_BEHIND)))).build();
    }

    @Nonnull
    public Duration getDurationBehind() {
        return this.shardDurationBehind.values().stream().max(Duration::compareTo).orElse(MAX_DURATION);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelDurationBehind that = (ChannelDurationBehind)o;
        return Objects.equals(this.shardDurationBehind, that.shardDurationBehind);
    }

    public int hashCode() {
        return Objects.hash(this.shardDurationBehind);
    }

    public String toString() {
        return "ChannelDurationBehind{shardDurationBehind=" + this.shardDurationBehind + '}';
    }

    public static Builder channelDurationBehind() {
        return new Builder();
    }

    public static Builder copyOf(@Nonnull ChannelDurationBehind prototype) {
        Builder builder = ChannelDurationBehind.channelDurationBehind();
        prototype.shardDurationBehind.forEach(builder::with);
        return builder;
    }

    public static class Builder {
        private final Map<String, Duration> shards = new LinkedHashMap<String, Duration>();

        public Builder with(@Nonnull String shardName, @Nonnull Duration behind) {
            this.shards.put(shardName, behind);
            return this;
        }

        public Builder withAll(Map<String, Duration> shards) {
            this.shards.putAll(shards);
            return this;
        }

        public ChannelDurationBehind build() {
            return new ChannelDurationBehind(this);
        }
    }
}

