/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.AbstractEventSource;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.MessageStore;
import java.time.Instant;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventSource
extends AbstractEventSource {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEventSource.class);
    private final MessageStore messageStore;

    public DefaultEventSource(@Nonnull MessageStore messageStore, @Nonnull MessageLogReceiverEndpoint messageLog) {
        super(messageLog);
        this.messageStore = messageStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ChannelPosition consumeUntil(@Nonnull ChannelPosition startFrom, @Nonnull Instant until) {
        try {
            ChannelPosition messageLogStartPosition;
            if (startFrom.equals(ChannelPosition.fromHorizon())) {
                this.messageStore.stream().forEach(message -> {
                    Message<String> interceptedMessage = this.getMessageLogReceiverEndpoint().getInterceptorChain().intercept((Message<String>)message);
                    if (interceptedMessage != null) {
                        this.getMessageLogReceiverEndpoint().getMessageDispatcher().accept(interceptedMessage);
                    }
                });
                messageLogStartPosition = this.messageStore.getLatestChannelPosition();
            } else {
                messageLogStartPosition = startFrom;
            }
            ChannelPosition channelPosition = this.getMessageLogReceiverEndpoint().consumeUntil(messageLogStartPosition, until);
            return channelPosition;
        }
        finally {
            try {
                this.messageStore.close();
            }
            catch (Exception e) {
                LOG.error("Unable to close() MessageStore: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

