/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import java.time.Instant;
import javax.annotation.Nonnull;

public interface EventSource {
    public void register(MessageConsumer<?> var1);

    @Nonnull
    public MessageDispatcher getMessageDispatcher();

    @Nonnull
    public MessageLogReceiverEndpoint getMessageLogReceiverEndpoint();

    public String getChannelName();

    default public ChannelPosition consume() {
        return this.consumeUntil(ChannelPosition.fromHorizon(), Instant.MAX);
    }

    default public ChannelPosition consume(ChannelPosition startFrom) {
        return this.consumeUntil(startFrom, Instant.MAX);
    }

    default public ChannelPosition consumeUntil(@Nonnull Instant until) {
        return this.consumeUntil(ChannelPosition.fromHorizon(), until);
    }

    @Nonnull
    public ChannelPosition consumeUntil(@Nonnull ChannelPosition var1, @Nonnull Instant var2);

    public void stop();

    public boolean isStopping();
}

