/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.MessageInterceptor;
import de.otto.synapse.message.Message;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MessageEndpoint {
    private final String channelName;
    private final InterceptorChain interceptorChain = new InterceptorChain();

    public MessageEndpoint(@Nonnull String channelName) {
        this.channelName = Objects.requireNonNull(channelName, "ChannelName must not be null");
    }

    @Nonnull
    public final String getChannelName() {
        return this.channelName;
    }

    public final void register(@Nonnull MessageInterceptor messageInterceptor) {
        this.interceptorChain.register(Objects.requireNonNull(messageInterceptor, "MessageInterceptor must not be null"));
    }

    @Nullable
    protected final Message<String> intercept(@Nonnull Message<String> message) {
        return this.interceptorChain.intercept(message);
    }
}

