/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.message;

import de.otto.synapse.channel.ShardPosition;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class Header
implements Serializable {
    private final ShardPosition shardPosition;
    private final Instant arrivalTimestamp;
    private final Duration durationBehind;

    public static Header emptyHeader() {
        return new Header(null, Instant.now(), null);
    }

    public static Header responseHeader(ShardPosition shardPosition, Instant arrivalTimestamp, Duration durationBehind) {
        return new Header(shardPosition, arrivalTimestamp, durationBehind);
    }

    public static Header responseHeader(ShardPosition shardPosition, Instant arrivalTimestamp) {
        return new Header(shardPosition, arrivalTimestamp, null);
    }

    private Header(ShardPosition shardPosition, Instant approximateArrivalTimestamp, Duration durationBehind) {
        this.shardPosition = shardPosition;
        this.arrivalTimestamp = Objects.requireNonNull(approximateArrivalTimestamp);
        this.durationBehind = durationBehind;
    }

    @Nonnull
    public Optional<ShardPosition> getShardPosition() {
        return Optional.ofNullable(this.shardPosition);
    }

    @Nonnull
    public Instant getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    @Nonnull
    public Optional<Duration> getDurationBehind() {
        return Optional.ofNullable(this.durationBehind);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.shardPosition, header.shardPosition) && Objects.equals(this.arrivalTimestamp, header.arrivalTimestamp) && Objects.equals(this.durationBehind, header.durationBehind);
    }

    public int hashCode() {
        return Objects.hash(this.shardPosition, this.arrivalTimestamp, this.durationBehind);
    }

    public String toString() {
        return "Header{shardPosition=" + this.shardPosition + ", arrivalTimestamp=" + this.arrivalTimestamp + ", durationBehind=" + this.durationBehind + '}';
    }
}

