/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.sender.InMemoryMessageSender;
import de.otto.synapse.endpoint.sender.MessageSenderEndpoint;
import de.otto.synapse.endpoint.sender.MessageSenderFactory;
import de.otto.synapse.translator.JsonStringMessageTranslator;

public class InMemoryMessageSenderFactory
implements MessageSenderFactory {
    private final MessageInterceptorRegistry registry;
    private final ObjectMapper objectMapper;
    private final InMemoryChannels inMemoryChannels;

    public InMemoryMessageSenderFactory(MessageInterceptorRegistry registry, InMemoryChannels inMemoryChannels, ObjectMapper objectMapper) {
        this.registry = registry;
        this.objectMapper = objectMapper;
        this.inMemoryChannels = inMemoryChannels;
    }

    @Override
    public MessageSenderEndpoint createSenderFor(String channelName) {
        InMemoryMessageSender messageSender = new InMemoryMessageSender(new JsonStringMessageTranslator(this.objectMapper), this.inMemoryChannels.getChannel(channelName));
        messageSender.registerInterceptorsFrom(this.registry);
        return messageSender;
    }
}

