/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.message.Message;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DelegateEventSource
implements EventSource,
ApplicationContextAware {
    private final String name;
    private final String channelName;
    private final String eventSourceBuilder;
    private EventSource delegate;

    public DelegateEventSource(String name, String channelName, String eventSourceBuilder) {
        this.name = name;
        this.channelName = channelName;
        this.eventSourceBuilder = eventSourceBuilder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EventSource getDelegate() {
        return this.delegate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.delegate = ((EventSourceBuilder)applicationContext.getBean(this.eventSourceBuilder, EventSourceBuilder.class)).buildEventSource(this.name, this.channelName);
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.delegate.register(messageConsumer);
    }

    @Override
    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.delegate.getMessageDispatcher();
    }

    @Override
    @Nonnull
    public String getChannelName() {
        return this.delegate.getChannelName();
    }

    @Override
    public ChannelPosition consume(ChannelPosition startFrom, Predicate<Message<?>> stopCondition) {
        return this.delegate.consume(startFrom, stopCondition);
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public boolean isStopping() {
        return this.delegate.isStopping();
    }

    public String toString() {
        return "DelegateEventSource{channelName='" + this.channelName + '\'' + ", eventSourceBuilder='" + this.eventSourceBuilder + '\'' + ", delegate=" + this.delegate + '}';
    }
}

