/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import java.util.Objects;

public class EventSourceNotification {
    private String eventSourceName;
    private ChannelPosition channelPosition;
    private String channelName;
    private Status status;
    private String message;

    protected EventSourceNotification(Builder builder) {
        this.eventSourceName = builder.eventSourceName;
        this.channelPosition = builder.channelPosition;
        this.channelName = builder.channelName;
        this.status = builder.status;
        this.message = builder.message;
    }

    public String getEventSourceName() {
        return this.eventSourceName;
    }

    public ChannelPosition getChannelPosition() {
        return this.channelPosition;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSourceNotification that = (EventSourceNotification)o;
        return Objects.equals(this.eventSourceName, that.eventSourceName) && Objects.equals(this.channelPosition, that.channelPosition) && Objects.equals(this.channelName, that.channelName) && this.status == that.status && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventSourceName, this.channelPosition, this.channelName, this.status, this.message});
    }

    public String toString() {
        return "EventSourceNotification{eventSourceName='" + this.eventSourceName + '\'' + ", channelPosition=" + this.channelPosition + ", channelName='" + this.channelName + '\'' + ", status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(EventSourceNotification copy) {
        Builder builder = new Builder();
        builder.channelPosition = copy.getChannelPosition();
        builder.channelName = copy.getChannelName();
        builder.status = copy.getStatus();
        return builder;
    }

    public static class Builder {
        private String eventSourceName;
        private ChannelPosition channelPosition;
        private String channelName;
        private Status status;
        private String message;

        protected Builder() {
        }

        public Builder withEventSourceName(String val) {
            this.eventSourceName = val;
            return this;
        }

        public Builder withChannelPosition(ChannelPosition val) {
            this.channelPosition = val;
            return this;
        }

        public Builder withChannelName(String val) {
            this.channelName = val;
            return this;
        }

        public Builder withStatus(Status val) {
            this.status = val;
            return this;
        }

        public Builder withMessage(String msg) {
            this.message = msg;
            return this;
        }

        public EventSourceNotification build() {
            return new EventSourceNotification(this);
        }
    }

    public static enum Status {
        STARTED,
        FAILED,
        FINISHED;

    }
}

