/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.InMemoryChannel;
import de.otto.synapse.eventsource.AbstractEventSource;
import de.otto.synapse.eventsource.EventSourceNotification;
import de.otto.synapse.message.Message;
import java.util.function.Predicate;
import org.springframework.context.ApplicationEventPublisher;

public class InMemoryEventSource
extends AbstractEventSource {
    private final InMemoryChannel inMemoryChannel;

    public InMemoryEventSource(String name, InMemoryChannel inMemoryChannel, ApplicationEventPublisher eventPublisher) {
        super(name, inMemoryChannel, eventPublisher);
        this.inMemoryChannel = inMemoryChannel;
    }

    @Override
    public ChannelPosition consume(ChannelPosition startFrom, Predicate<Message<?>> stopCondition) {
        this.publishEvent(startFrom, EventSourceNotification.Status.STARTED);
        ChannelPosition currentPosition = this.inMemoryChannel.consume(startFrom, stopCondition);
        this.publishEvent(currentPosition, EventSourceNotification.Status.FINISHED);
        return currentPosition;
    }
}

