/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.MessageStore;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryMessageStore
implements MessageStore {
    private final Deque<Message<String>> messages = new ConcurrentLinkedDeque<Message<String>>();
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());

    @Override
    public void add(Message<String> message) {
        this.messages.add(message);
        this.latestChannelPosition.updateAndGet(previous -> {
            Optional<ShardPosition> optionalMessagePosition = message.getHeader().getShardPosition();
            return optionalMessagePosition.map(messagePosition -> ChannelPosition.merge(previous, ChannelPosition.channelPosition(messagePosition))).orElse((ChannelPosition)previous);
        });
    }

    @Override
    public ChannelPosition getLatestChannelPosition() {
        return this.latestChannelPosition.get();
    }

    @Override
    public Stream<Message<String>> stream() {
        return this.messages.stream();
    }

    @Override
    public int size() {
        return this.messages.size();
    }
}

