/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.consumer;

import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.message.Message;
import de.otto.synapse.state.StateRepository;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class DefaultMessageConsumer<T>
implements MessageConsumer<T> {
    private final Pattern keyPattern;
    private final StateRepository<T> stateRepository;
    private final Class<T> payloadType;

    public DefaultMessageConsumer(String keyPattern, Class<T> payloadType, StateRepository<T> stateRepository) {
        this.keyPattern = Pattern.compile(keyPattern);
        this.payloadType = payloadType;
        this.stateRepository = stateRepository;
    }

    @Override
    @Nonnull
    public Class<T> payloadType() {
        return this.payloadType;
    }

    @Override
    @Nonnull
    public Pattern keyPattern() {
        return this.keyPattern;
    }

    @Override
    public void accept(Message<T> message) {
        if (message.getPayload() == null) {
            this.stateRepository.remove(message.getKey());
        } else {
            this.stateRepository.put(message.getKey(), message.getPayload());
        }
    }
}

