/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageInterceptor;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class MessageInterceptorRegistration {
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    private final Pattern channelNamePattern;
    private final MessageInterceptor interceptor;
    private final Set<EndpointType> enabledEndpointTypes;

    public static MessageInterceptorRegistration allChannelsWith(@Nonnull MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(MATCH_ALL, interceptor, EnumSet.allOf(EndpointType.class));
    }

    public static MessageInterceptorRegistration matchingChannelsWith(@Nonnull String channelNamePattern, @Nonnull MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(Pattern.compile(channelNamePattern), interceptor, EnumSet.allOf(EndpointType.class));
    }

    public static MessageInterceptorRegistration receiverChannelsWith(@Nonnull MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(MATCH_ALL, interceptor, EnumSet.of(EndpointType.RECEIVER));
    }

    public static MessageInterceptorRegistration matchingReceiverChannelsWith(@Nonnull String channelNamePattern, @Nonnull MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(Pattern.compile(channelNamePattern), interceptor, EnumSet.of(EndpointType.RECEIVER));
    }

    public static MessageInterceptorRegistration senderChannelsWith(@Nonnull MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(MATCH_ALL, interceptor, EnumSet.of(EndpointType.SENDER));
    }

    public static MessageInterceptorRegistration matchingSenderChannelsWith(@Nonnull String channelNamePattern, @Nonnull MessageInterceptor interceptor) {
        return new MessageInterceptorRegistration(Pattern.compile(channelNamePattern), interceptor, EnumSet.of(EndpointType.SENDER));
    }

    private MessageInterceptorRegistration(Pattern channelNamePattern, MessageInterceptor interceptor, Set<EndpointType> enabledEndpointTypes) {
        this.channelNamePattern = Objects.requireNonNull(channelNamePattern);
        this.interceptor = Objects.requireNonNull(interceptor);
        this.enabledEndpointTypes = Objects.requireNonNull(enabledEndpointTypes);
        if (enabledEndpointTypes.isEmpty()) {
            throw new IllegalArgumentException("The set of enabled endpoint types must not be empty");
        }
    }

    public MessageInterceptor getInterceptor() {
        return this.interceptor;
    }

    public boolean isEnabledFor(String channelName, EndpointType endpointType) {
        return this.enabledEndpointTypes.contains((Object)endpointType) && this.channelNamePattern.matcher(channelName).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageInterceptorRegistration that = (MessageInterceptorRegistration)o;
        return Objects.equals(this.channelNamePattern.pattern(), that.channelNamePattern.pattern()) && Objects.equals(this.interceptor, that.interceptor) && Objects.equals(this.enabledEndpointTypes, that.enabledEndpointTypes);
    }

    public int hashCode() {
        return Objects.hash(this.channelNamePattern.pattern(), this.interceptor, this.enabledEndpointTypes);
    }

    public String toString() {
        return "MessageInterceptorRegistration{channelNamePattern=" + this.channelNamePattern.pattern() + ", interceptor=" + this.interceptor + ", enabledEndpointTypes=" + this.enabledEndpointTypes + '}';
    }
}

