/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.sender;

import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.message.Message;
import de.otto.synapse.translator.MessageTranslator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class MessageSenderEndpoint
extends MessageEndpoint {
    private final MessageTranslator<String> messageTranslator;

    public MessageSenderEndpoint(String channelName, MessageTranslator<String> messageTranslator) {
        super(channelName);
        this.messageTranslator = messageTranslator;
    }

    public final <T> void send(Message<T> message) {
        Message<String> translatedMessage = this.messageTranslator.translate(message);
        Message<String> interceptedMessage = this.intercept(translatedMessage);
        if (interceptedMessage != null) {
            this.doSend(interceptedMessage);
        }
    }

    public final <T> void sendBatch(Stream<Message<T>> batch) {
        this.doSendBatch(batch.map(this.messageTranslator::translate).map(this::intercept).filter(Objects::nonNull));
    }

    @Override
    protected final EndpointType getEndpointType() {
        return EndpointType.SENDER;
    }

    protected void doSendBatch(@Nonnull Stream<Message<String>> batch) {
        batch.forEach(this::doSend);
    }

    protected abstract void doSend(@Nonnull Message<String> var1);
}

