/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpoint;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceNotification;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public abstract class AbstractEventSource
implements EventSource {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventSource.class);
    private final String name;
    private final MessageLogReceiverEndpoint messageLog;
    private final ApplicationEventPublisher eventPublisher;
    private final AtomicBoolean stopping = new AtomicBoolean(false);

    public AbstractEventSource(String name, MessageLogReceiverEndpoint messageLog, ApplicationEventPublisher eventPublisher) {
        this.name = name;
        this.messageLog = messageLog;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getChannelName() {
        return this.messageLog.getChannelName();
    }

    @Override
    public void stop() {
        LOG.info("Stopping EventSource {}", (Object)this.name);
        this.stopping.set(true);
        this.messageLog.stop();
    }

    @Override
    public boolean isStopping() {
        return this.stopping.get();
    }

    @Override
    public void register(MessageConsumer<?> messageConsumer) {
        this.messageLog.register(messageConsumer);
    }

    @Override
    @Nonnull
    public MessageDispatcher getMessageDispatcher() {
        return this.messageLog.getMessageDispatcher();
    }

    protected void publishEvent(ChannelPosition channelPosition, EventSourceNotification.Status status) {
        this.publishEvent(channelPosition, status, "");
    }

    protected void publishEvent(ChannelPosition channelPosition, EventSourceNotification.Status status, String message) {
        if (this.eventPublisher != null) {
            EventSourceNotification notification = EventSourceNotification.builder().withEventSourceName(this.name).withChannelName(this.getChannelName()).withChannelPosition(channelPosition).withStatus(status).withMessage(message).build();
            try {
                this.eventPublisher.publishEvent((Object)notification);
            }
            catch (Exception e) {
                LOG.error("error publishing event source notification: {}", (Object)notification, (Object)e);
            }
        }
    }
}

