/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.eventsource;

import de.otto.synapse.channel.InMemoryChannel;
import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.InMemoryEventSource;
import org.springframework.context.ApplicationEventPublisher;

public class InMemoryEventSourceBuilder
implements EventSourceBuilder {
    private final MessageInterceptorRegistry interceptorRegistry;
    private final InMemoryChannels inMemoryChannels;
    private final ApplicationEventPublisher eventPublisher;

    public InMemoryEventSourceBuilder(MessageInterceptorRegistry interceptorRegistry, InMemoryChannels inMemoryChannels, ApplicationEventPublisher eventPublisher) {
        this.interceptorRegistry = interceptorRegistry;
        this.inMemoryChannels = inMemoryChannels;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public EventSource buildEventSource(String name, String channelName) {
        InMemoryChannel channel = this.inMemoryChannels.getChannel(channelName);
        channel.registerInterceptorsFrom(this.interceptorRegistry);
        return new InMemoryEventSource(name, channel, this.eventPublisher);
    }
}

