/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.channel;

import de.otto.synapse.channel.StartFrom;
import java.io.Serializable;
import java.time.Instant;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ShardPosition
implements Serializable {
    private final String shardName;
    private final String position;
    private final StartFrom startFrom;
    private final Instant timestamp;

    private ShardPosition(@Nonnull String shardName, @Nonnull String position) {
        this.shardName = Objects.requireNonNull(shardName);
        this.position = Objects.requireNonNull(position);
        this.timestamp = null;
        this.startFrom = position.isEmpty() ? StartFrom.HORIZON : StartFrom.POSITION;
    }

    private ShardPosition(@Nonnull String shardName, @Nonnull Instant timestamp) {
        this.shardName = Objects.requireNonNull(shardName);
        this.position = "";
        this.timestamp = Objects.requireNonNull(timestamp);
        this.startFrom = StartFrom.TIMESTAMP;
    }

    @Nonnull
    public static ShardPosition fromHorizon(@Nonnull String shardName) {
        return new ShardPosition(shardName, "");
    }

    @Nonnull
    public static ShardPosition fromPosition(@Nonnull String shardName, @Nonnull String position) {
        return new ShardPosition(shardName, position);
    }

    @Nonnull
    public static ShardPosition fromTimestamp(@Nonnull String shardName, @Nonnull Instant timestamp) {
        return new ShardPosition(shardName, timestamp);
    }

    public String shardName() {
        return this.shardName;
    }

    @Nonnull
    public String position() {
        return this.position;
    }

    @Nonnull
    public Instant timestamp() {
        return this.timestamp;
    }

    @Nonnull
    public StartFrom startFrom() {
        return this.startFrom;
    }

    public String toString() {
        return "ShardPosition{shardName='" + this.shardName + '\'' + ", position='" + this.position + '\'' + ", startFrom=" + (Object)((Object)this.startFrom) + ", timestamp=" + this.timestamp + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardPosition that = (ShardPosition)o;
        return Objects.equals(this.shardName, that.shardName) && Objects.equals(this.position, that.position) && this.startFrom == that.startFrom && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shardName, this.position, this.startFrom, this.timestamp});
    }
}

