/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.message.Message;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MessageEndpoint {
    private final String channelName;
    private final InterceptorChain interceptorChain = new InterceptorChain();

    public MessageEndpoint(@Nonnull String channelName) {
        this.channelName = Objects.requireNonNull(channelName, "ChannelName must not be null");
    }

    @Nonnull
    public final String getChannelName() {
        return this.channelName;
    }

    public final InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    public final void registerInterceptorsFrom(@Nonnull MessageInterceptorRegistry registry) {
        registry.getRegistrations(this.channelName, this.getEndpointType()).forEach(reg -> this.interceptorChain.register(reg.getInterceptor()));
    }

    protected abstract EndpointType getEndpointType();

    @Nullable
    protected final Message<String> intercept(@Nonnull Message<String> message) {
        return this.interceptorChain.intercept(message);
    }
}

