/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint.receiver;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.ChannelDurationBehind;
import de.otto.synapse.consumer.MessageConsumer;
import de.otto.synapse.consumer.MessageDispatcher;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.info.MessageReceiverNotification;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.context.ApplicationEventPublisher;

public class MessageReceiverEndpoint
extends MessageEndpoint {
    private final MessageDispatcher messageDispatcher;
    private final ApplicationEventPublisher eventPublisher;

    public MessageReceiverEndpoint(@Nonnull String channelName, @Nonnull ObjectMapper objectMapper, @Nullable ApplicationEventPublisher eventPublisher) {
        super(channelName);
        this.messageDispatcher = new MessageDispatcher(objectMapper);
        this.eventPublisher = eventPublisher;
    }

    public final void register(MessageConsumer<?> messageConsumer) {
        this.messageDispatcher.add(messageConsumer);
    }

    public final MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    @Override
    protected final EndpointType getEndpointType() {
        return EndpointType.RECEIVER;
    }

    protected void publishEvent(@Nonnull MessageReceiverStatus status, @Nullable String message, @Nullable ChannelDurationBehind durationBehind) {
        if (this.eventPublisher != null) {
            MessageReceiverNotification notification = MessageReceiverNotification.builder().withChannelName(this.getChannelName()).withChannelDurationBehind(durationBehind).withStatus(status).withMessage(Objects.toString(message, "")).build();
            this.eventPublisher.publishEvent((Object)notification);
        }
    }
}

