/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.otto.synapse.annotation.EventSourceConsumerBeanPostProcessor;
import de.otto.synapse.configuration.ConsumerProcessProperties;
import de.otto.synapse.configuration.MessageEndpointConfigurer;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.eventsource.DefaultEventSource;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.EventSourceConsumerProcess;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@EnableConfigurationProperties(value={ConsumerProcessProperties.class})
public class SynapseAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SynapseAutoConfiguration.class);
    @Autowired(required=false)
    private List<EventSource> eventSources;
    private MessageInterceptorRegistry registry;

    @Bean
    @ConditionalOnMissingBean
    public EventSourceBuilder eventSourceBuilder(MessageStoreFactory<MessageStore> snapshotMessageStoreFactory) {
        return messageLog -> {
            Object messageStore = snapshotMessageStoreFactory.createMessageStoreFor(messageLog.getChannelName());
            return new DefaultEventSource((MessageStore)messageStore, messageLog);
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
    public EventSourceConsumerProcess eventSourceConsumerProcess() {
        return new EventSourceConsumerProcess(this.eventSources);
    }

    @Bean
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper objectMapper() {
        return new ObjectMapper().registerModule((Module)new JavaTimeModule());
    }

    @Bean
    public MessageInterceptorRegistry messageInterceptorRegistry(ApplicationContext applicationContext) {
        if (this.registry == null) {
            this.registry = new MessageInterceptorRegistry();
            Map configurers = applicationContext.getBeansOfType(MessageEndpointConfigurer.class);
            if (configurers != null) {
                configurers.forEach((beanName, bean) -> {
                    LOG.info("Configuring MessageEndpointConfigurer '" + beanName + "'");
                    bean.configureMessageInterceptors(this.registry);
                });
            }
        }
        return this.registry;
    }

    @Bean
    @Role(value=2)
    public EventSourceConsumerBeanPostProcessor eventSourceConsumerAnnotationBeanPostProcessor() {
        return new EventSourceConsumerBeanPostProcessor();
    }
}

