/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.channel.InMemoryChannels;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageLogReceiverEndpointFactory;
import de.otto.synapse.endpoint.sender.InMemoryMessageSenderFactory;
import de.otto.synapse.endpoint.sender.MessageSenderEndpointFactory;
import de.otto.synapse.eventsource.InMemoryMessageLogReceiverEndpointFactory;
import de.otto.synapse.messagestore.CompactingInMemoryMessageStore;
import de.otto.synapse.messagestore.MessageStore;
import de.otto.synapse.messagestore.MessageStoreFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;

public class InMemoryTestConfiguration {
    @Bean
    public InMemoryChannels inMemoryChannels(ObjectMapper objectMapper, ApplicationEventPublisher eventPublisher) {
        return new InMemoryChannels(objectMapper, eventPublisher);
    }

    @Bean
    public MessageSenderEndpointFactory messageSenderEndpointFactory(MessageInterceptorRegistry interceptorRegistry, InMemoryChannels inMemoryChannels, ObjectMapper objectMapper) {
        return new InMemoryMessageSenderFactory(interceptorRegistry, inMemoryChannels, objectMapper);
    }

    @Bean
    public MessageStoreFactory<MessageStore> snapshotMessageStoreFactory() {
        return channelName -> new CompactingInMemoryMessageStore(true);
    }

    @Bean
    public MessageLogReceiverEndpointFactory messageLogReceiverEndpointFactory(MessageInterceptorRegistry interceptorRegistry, InMemoryChannels inMemoryChannels) {
        return new InMemoryMessageLogReceiverEndpointFactory(interceptorRegistry, inMemoryChannels);
    }
}

