/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.InterceptorChain;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.message.Message;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMessageEndpoint
implements MessageEndpoint {
    private final String channelName;
    private final InterceptorChain interceptorChain = new InterceptorChain();

    public AbstractMessageEndpoint(@Nonnull String channelName) {
        this.channelName = Objects.requireNonNull(channelName, "ChannelName must not be null");
    }

    @Override
    @Nonnull
    public final String getChannelName() {
        return this.channelName;
    }

    @Override
    @Nonnull
    public final InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public final void registerInterceptorsFrom(@Nonnull MessageInterceptorRegistry registry) {
        registry.getRegistrations(this.channelName, this.getEndpointType()).forEach(reg -> this.interceptorChain.register(reg.getInterceptor()));
    }

    @Override
    @Nullable
    public final Message<String> intercept(@Nonnull Message<String> message) {
        return this.interceptorChain.intercept(message);
    }
}

