/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.messagestore;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import de.otto.synapse.channel.ChannelPosition;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.message.Message;
import de.otto.synapse.messagestore.WritableMessageStore;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryRingBufferMessageStore
implements WritableMessageStore {
    private final Queue<Message<String>> messages;
    private final AtomicReference<ChannelPosition> latestChannelPosition = new AtomicReference<ChannelPosition>(ChannelPosition.fromHorizon());

    public InMemoryRingBufferMessageStore() {
        this.messages = EvictingQueue.create((int)100);
    }

    public InMemoryRingBufferMessageStore(int capacity) {
        this.messages = EvictingQueue.create((int)capacity);
    }

    @Override
    public synchronized void add(Message<String> message) {
        this.messages.add(message);
        this.latestChannelPosition.updateAndGet(previous -> {
            Optional<ShardPosition> optionalMessagePosition = message.getHeader().getShardPosition();
            return optionalMessagePosition.map(messagePosition -> ChannelPosition.merge(previous, ChannelPosition.channelPosition(messagePosition))).orElse((ChannelPosition)previous);
        });
    }

    @Override
    public synchronized ChannelPosition getLatestChannelPosition() {
        return this.latestChannelPosition.get();
    }

    @Override
    public synchronized Stream<Message<String>> stream() {
        return ImmutableList.copyOf(this.messages).stream();
    }

    @Override
    public synchronized int size() {
        return this.messages.size();
    }
}

