/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.annotation.messagequeue;

import de.otto.synapse.annotation.messagequeue.MessageQueueConsumer;
import de.otto.synapse.consumer.MethodInvokingMessageConsumer;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpoint;
import de.otto.synapse.endpoint.receiver.MessageReceiverEndpoint;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;

public class MessageQueueConsumerBeanPostProcessor
implements BeanPostProcessor,
Ordered,
ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(MessageQueueConsumerBeanPostProcessor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private ConfigurableApplicationContext applicationContext;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            Map<Method, Set<MessageQueueConsumer>> annotatedMethods = this.findMethodsAnnotatedWithMessageQueueConsumer(targetClass);
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
                LOG.trace("No @MessageQueueConsumer annotations found on bean type: {}", bean.getClass());
            } else {
                this.registerMessageQueueConsumers(bean, beanName, annotatedMethods);
            }
        }
        return bean;
    }

    private Map<Method, Set<MessageQueueConsumer>> findMethodsAnnotatedWithMessageQueueConsumer(Class<?> targetClass) {
        return MethodIntrospector.selectMethods(targetClass, method -> {
            Set<MessageQueueConsumer> consumerAnnotations = this.consumerAnnotationsOf(method);
            return !consumerAnnotations.isEmpty() ? consumerAnnotations : null;
        });
    }

    private void registerMessageQueueConsumers(Object bean, String beanName, Map<Method, Set<MessageQueueConsumer>> annotatedMethods) {
        for (Map.Entry<Method, Set<MessageQueueConsumer>> entry : annotatedMethods.entrySet()) {
            Method method = entry.getKey();
            for (MessageQueueConsumer consumerAnnotation : entry.getValue()) {
                this.matchingMessageQueueReceiverEndpointFor(consumerAnnotation).register(this.messageQueueConsumerFor(consumerAnnotation, method, bean));
            }
        }
        LOG.info("{} @MessageQueueConsumer methods processed on bean {} : {}'", new Object[]{annotatedMethods.size(), beanName, annotatedMethods});
    }

    private Set<MessageQueueConsumer> consumerAnnotationsOf(Method method) {
        HashSet<MessageQueueConsumer> listeners = new HashSet<MessageQueueConsumer>();
        MessageQueueConsumer ann = (MessageQueueConsumer)AnnotationUtils.findAnnotation((Method)method, MessageQueueConsumer.class);
        if (ann != null) {
            listeners.add(ann);
        }
        return listeners;
    }

    private MethodInvokingMessageConsumer<?> messageQueueConsumerFor(MessageQueueConsumer annotation, Method annotatedMethod, Object bean) {
        return new MethodInvokingMessageConsumer(annotation.keyPattern(), annotation.payloadType(), bean, annotatedMethod);
    }

    private MessageReceiverEndpoint matchingMessageQueueReceiverEndpointFor(MessageQueueConsumer annotation) {
        return (MessageReceiverEndpoint)this.applicationContext.getBean(annotation.endpointName(), MessageQueueReceiverEndpoint.class);
    }
}

