/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.endpoint;

import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageInterceptorRegistration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MessageInterceptorRegistry {
    private final List<MessageInterceptorRegistration> registry = Collections.synchronizedList(new ArrayList());

    public void register(@Nonnull MessageInterceptorRegistration registration) {
        this.registry.add(registration);
    }

    @Nonnull
    public List<MessageInterceptorRegistration> getRegistrations(String channelName, EndpointType endpointType) {
        return this.registry.stream().filter(registration -> registration.isEnabledFor(channelName, endpointType)).collect(Collectors.toList());
    }
}

