/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.otto.synapse.annotation.EventSourceConsumerBeanPostProcessor;
import de.otto.synapse.annotation.messagequeue.MessageQueueConsumerBeanPostProcessor;
import de.otto.synapse.configuration.ConsumerProcessProperties;
import de.otto.synapse.configuration.MessageEndpointConfigurer;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.endpoint.receiver.MessageQueueConsumerProcess;
import de.otto.synapse.endpoint.receiver.MessageQueueReceiverEndpoint;
import de.otto.synapse.eventsource.DefaultEventSource;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.eventsource.EventSourceBuilder;
import de.otto.synapse.eventsource.EventSourceConsumerProcess;
import de.otto.synapse.messagestore.MessageStoreFactory;
import de.otto.synapse.messagestore.SnapshotMessageStore;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@EnableConfigurationProperties(value={ConsumerProcessProperties.class})
public class SynapseAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SynapseAutoConfiguration.class);
    @Autowired(required=false)
    private List<EventSource> eventSources;
    @Autowired(required=false)
    private List<MessageQueueReceiverEndpoint> messageQueueReceiverEndpoints;
    private MessageInterceptorRegistry registry;

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.findAndRegisterModules();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventSourceBuilder eventSourceBuilder(MessageStoreFactory<SnapshotMessageStore> snapshotMessageStoreFactory) {
        return messageLog -> {
            SnapshotMessageStore messageStore = (SnapshotMessageStore)snapshotMessageStoreFactory.createMessageStoreFor(messageLog.getChannelName());
            return new DefaultEventSource(messageStore, messageLog);
        };
    }

    @Bean
    @ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
    public EventSourceConsumerProcess eventSourceConsumerProcess() {
        return new EventSourceConsumerProcess(this.eventSources);
    }

    @Bean
    @ConditionalOnProperty(prefix="synapse", name={"consumer-process.enabled"}, havingValue="true", matchIfMissing=true)
    public MessageQueueConsumerProcess messageQueueConsumerProcess() {
        return new MessageQueueConsumerProcess(this.messageQueueReceiverEndpoints);
    }

    @Bean
    public MessageInterceptorRegistry messageInterceptorRegistry(ApplicationContext applicationContext) {
        if (this.registry == null) {
            this.registry = new MessageInterceptorRegistry();
            Map configurers = applicationContext.getBeansOfType(MessageEndpointConfigurer.class);
            if (configurers != null) {
                configurers.forEach((beanName, bean) -> {
                    LOG.info("Configuring MessageEndpointConfigurer '" + beanName + "'");
                    bean.configureMessageInterceptors(this.registry);
                });
            }
        }
        return this.registry;
    }

    @Bean
    @Role(value=2)
    public EventSourceConsumerBeanPostProcessor eventSourceConsumerAnnotationBeanPostProcessor() {
        return new EventSourceConsumerBeanPostProcessor();
    }

    @Bean
    @Role(value=2)
    public MessageQueueConsumerBeanPostProcessor messageQueueConsumerAnnotationBeanPostProcessor() {
        return new MessageQueueConsumerBeanPostProcessor();
    }
}

