/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.translator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.otto.synapse.message.Message;
import de.otto.synapse.message.Messages;
import de.otto.synapse.translator.MessageTranslator;
import javax.annotation.Nonnull;

public class JsonStringMessageTranslator
implements MessageTranslator<String> {
    private final ObjectMapper objectMapper;

    public JsonStringMessageTranslator(@Nonnull ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    @Nonnull
    public Message<String> translate(@Nonnull Message<?> message) {
        try {
            if (message.getPayload() instanceof String) {
                return message;
            }
            String payload = message.getPayload() != null ? this.objectMapper.writeValueAsString((Object)message.getPayload()) : null;
            return Messages.stringMessage(message.getKey(), message.getHeader(), payload);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

