/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import de.otto.synapse.edison.trace.TraceEntry;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.message.Message;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MessageTrace {
    private final Queue<TraceEntry> traceEntries;
    private final ImmutableList<RegisteredEndpoints> registeredEndpoints;

    public MessageTrace(int capacity, Iterable<MessageEndpoint> endpoints) {
        this.traceEntries = EvictingQueue.create((int)capacity);
        ImmutableList.Builder builder = ImmutableList.builder();
        endpoints.forEach(messageEndpoint -> {
            builder.add((Object)new RegisteredEndpoints((MessageEndpoint)messageEndpoint));
            messageEndpoint.getInterceptorChain().register(message -> {
                this.add(new TraceEntry(messageEndpoint.getChannelName(), messageEndpoint.getEndpointType(), (Message<String>)message));
                return message;
            });
        });
        this.registeredEndpoints = builder.build();
    }

    public List<String> getSenderChannels() {
        return this.registeredEndpoints.stream().filter(registeredEndpoint -> registeredEndpoint.getEndpointType().equals((Object)EndpointType.SENDER)).map(RegisteredEndpoints::getChannelName).collect(Collectors.toList());
    }

    public List<String> getReceiverChannels() {
        return this.registeredEndpoints.stream().filter(registeredEndpoint -> registeredEndpoint.getEndpointType().equals((Object)EndpointType.RECEIVER)).map(RegisteredEndpoints::getChannelName).collect(Collectors.toList());
    }

    public synchronized void add(TraceEntry traceEntry) {
        this.traceEntries.add(traceEntry);
    }

    public synchronized Stream<TraceEntry> stream() {
        return ImmutableList.copyOf(this.traceEntries).stream();
    }

    public synchronized Stream<TraceEntry> stream(String channelName, EndpointType endpointType) {
        return ImmutableList.copyOf(this.traceEntries).stream().filter(traceEntry -> traceEntry.getChannelName().equals(channelName) && traceEntry.getEndpointType().equals((Object)endpointType));
    }

    private static final class RegisteredEndpoints {
        private final String channelName;
        private final EndpointType endpointType;

        RegisteredEndpoints(MessageEndpoint messageEndpoint) {
            this.channelName = messageEndpoint.getChannelName();
            this.endpointType = messageEndpoint.getEndpointType();
        }

        String getChannelName() {
            return this.channelName;
        }

        EndpointType getEndpointType() {
            return this.endpointType;
        }
    }
}

