/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.edison.navigation.NavBar;
import de.otto.edison.navigation.NavBarItem;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.edison.trace.MessageTrace;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.message.Header;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ConditionalOnBean(value={MessageTrace.class})
public class MessageTraceController {
    private final MessageTrace messageTrace;
    private final ObjectMapper objectMapper;

    @Autowired
    MessageTraceController(MessageTrace messageTrace, NavBar rightNavBar, ManagementServerProperties managementServerProperties, ObjectMapper objectMapper) {
        this.messageTrace = messageTrace;
        this.objectMapper = objectMapper;
        rightNavBar.register(NavBarItem.navBarItem((int)10, (String)"Message Trace", (String)String.format("%s/messagetrace", managementServerProperties.getContextPath())));
        messageTrace.getSenderChannels().forEach(channelName -> rightNavBar.register(NavBarItem.navBarItem((int)11, (String)("Sender: " + channelName), (String)String.format("%s/messagetrace/sender/%s", managementServerProperties.getContextPath(), channelName))));
        messageTrace.getReceiverChannels().forEach(channelName -> rightNavBar.register(NavBarItem.navBarItem((int)12, (String)("Receiver: " + channelName), (String)String.format("%s/messagetrace/receiver/%s", managementServerProperties.getContextPath(), channelName))));
    }

    @GetMapping(path={"${management.context-path}/messagetrace/{endpointType}/{channelName}"}, produces={"text/html"})
    public ModelAndView getMessageTrace(@PathVariable String endpointType, @PathVariable String channelName) {
        return new ModelAndView("single-channel-trace", (Map)ImmutableMap.of((Object)"title", (Object)(endpointType.equals("receiver") ? "Receiver: " : "Sender: " + channelName), (Object)"messages", this.messageTrace.stream(channelName, EndpointType.valueOf((String)endpointType.toUpperCase())).map(traceEntry -> ImmutableMap.of((Object)"sequenceNumber", (Object)traceEntry.getSequenceNumber(), (Object)"key", (Object)traceEntry.getMessage().getKey(), (Object)"header", (Object)this.prettyPrint(traceEntry.getMessage().getHeader()), (Object)"payload", (Object)this.prettyPrint((String)traceEntry.getMessage().getPayload()))).collect(Collectors.toList())));
    }

    @GetMapping(path={"${management.context-path}/messagetrace"}, produces={"text/html"})
    public ModelAndView getMessageTrace() {
        return new ModelAndView("multi-channel-trace", (Map)ImmutableMap.of((Object)"title", (Object)"Message Trace", (Object)"messages", this.messageTrace.stream().map(traceEntry -> ImmutableMap.builder().put((Object)"sequenceNumber", (Object)traceEntry.getSequenceNumber()).put((Object)"ts", (Object)LocalDateTime.ofInstant(traceEntry.getTimestamp(), ZoneId.systemDefault()).toString()).put((Object)"channelName", (Object)traceEntry.getChannelName()).put((Object)"endpointType", (Object)traceEntry.getEndpointType().name()).put((Object)"key", (Object)traceEntry.getMessage().getKey()).put((Object)"header", (Object)this.prettyPrint(traceEntry.getMessage().getHeader())).put((Object)"payload", (Object)this.prettyPrint((String)traceEntry.getMessage().getPayload())).build()).collect(Collectors.toList())));
    }

    private String prettyPrint(String json) {
        try {
            Object jsonObject = this.objectMapper.readValue(json, Object.class);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String prettyPrint(Header header) {
        try {
            LinkedHashMap map = Maps.newLinkedHashMap();
            map.put("shardPosition", header.getShardPosition().map(ShardPosition::toString).orElse(""));
            map.put("arrivalTimestamp", header.getArrivalTimestamp().toString());
            map.put("attributes", header.getAttributes());
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

