/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import de.otto.edison.navigation.NavBar;
import de.otto.edison.navigation.NavBarItem;
import de.otto.synapse.edison.trace.MessageTrace;
import de.otto.synapse.edison.trace.TraceEntry;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.endpoint.MessageEndpoint;
import de.otto.synapse.endpoint.MessageInterceptorRegistration;
import de.otto.synapse.endpoint.MessageInterceptorRegistry;
import de.otto.synapse.message.Message;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="synapse.edison.trace", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MessageTraceAutoConfiguration {
    @Value(value="${synapse.edison.trace.capacity:500}")
    private int capacity = 500;

    @Bean
    @ConditionalOnMissingBean
    public MessageTrace messageTrace(MessageInterceptorRegistry interceptorRegistry, NavBar rightNavBar, ManagementServerProperties managementServerProperties, Optional<List<? extends MessageEndpoint>> endpoints) {
        String contextPath = managementServerProperties.getContextPath();
        rightNavBar.register(NavBarItem.navBarItem((int)10, (String)"Message Trace", (String)String.format("%s/messagetrace", contextPath)));
        MessageTrace messageTrace = new MessageTrace(this.capacity);
        endpoints.orElse(Collections.emptyList()).forEach(endpoint -> {
            String channelName = endpoint.getChannelName();
            EndpointType endpointType = endpoint.getEndpointType();
            interceptorRegistry.register(MessageInterceptorRegistration.matchingChannelsWith((String)channelName, message -> {
                messageTrace.add(new TraceEntry(channelName, endpointType, (Message<String>)message));
                return message;
            }));
            switch (endpointType) {
                case SENDER: {
                    rightNavBar.register(NavBarItem.navBarItem((int)11, (String)("Sender: " + channelName), (String)String.format("%s/messagetrace/sender/%s", contextPath, channelName)));
                    break;
                }
                case RECEIVER: {
                    rightNavBar.register(NavBarItem.navBarItem((int)12, (String)("Receiver: " + channelName), (String)String.format("%s/messagetrace/receiver/%s", contextPath, channelName)));
                }
            }
        });
        return messageTrace;
    }
}

