/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.history;

import de.otto.synapse.edison.history.HistoryService;
import de.otto.synapse.translator.ObjectMappers;
import java.util.Collections;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@ConditionalOnProperty(prefix="synapse.edison.history", name={"enabled"}, havingValue="true")
@Controller
public class HistoryController {
    private final HistoryService historyService;

    public HistoryController(HistoryService historyService) {
        this.historyService = historyService;
    }

    @GetMapping(value={"${management.context-path}/history/{type}/{entityId}"}, produces={"application/json"})
    public ResponseEntity<Map<String, ?>> getHistoryAsJson(@PathVariable String type, @PathVariable String entityId) {
        return ResponseEntity.ok(Collections.singletonMap("history", ObjectMappers.currentObjectMapper().convertValue((Object)this.historyService.getHistory(type, entityId), Map.class)));
    }
}

