/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.trace;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.synapse.channel.ShardPosition;
import de.otto.synapse.edison.trace.MessageTrace;
import de.otto.synapse.endpoint.EndpointType;
import de.otto.synapse.message.Header;
import de.otto.synapse.message.Key;
import de.otto.synapse.translator.ObjectMappers;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.servlet.ModelAndView;

@Controller
@ConditionalOnProperty(prefix="synapse.edison.trace", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MessageTraceController {
    private final MessageTrace messageTrace;

    @Autowired
    MessageTraceController(MessageTrace messageTrace) {
        this.messageTrace = messageTrace;
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/messagetrace/{endpointType}/{channelName}"}, produces={"text/html"})
    public ModelAndView getMessageTrace(@PathVariable String endpointType, @PathVariable String channelName) {
        return new ModelAndView("single-channel-trace", (Map)ImmutableMap.of((Object)"title", (Object)(endpointType.equals("receiver") ? "Receiver: " : "Sender: " + channelName), (Object)"messages", this.messageTrace.stream(channelName, EndpointType.valueOf((String)endpointType.toUpperCase())).map(traceEntry -> ImmutableMap.of((Object)"sequenceNumber", (Object)traceEntry.getSequenceNumber(), (Object)"key", (Object)this.prettyPrint(traceEntry.getMessage().getKey()), (Object)"header", (Object)this.prettyPrint(traceEntry.getMessage().getHeader()), (Object)"payload", (Object)this.prettyPrint((String)traceEntry.getMessage().getPayload()))).collect(Collectors.toList())));
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/messagetrace"}, produces={"text/html"})
    public ModelAndView getMessageTrace() {
        return new ModelAndView("multi-channel-trace", (Map)ImmutableMap.of((Object)"title", (Object)"Message Trace", (Object)"messages", this.messageTrace.stream().map(traceEntry -> ImmutableMap.builder().put((Object)"sequenceNumber", (Object)traceEntry.getSequenceNumber()).put((Object)"ts", (Object)LocalDateTime.ofInstant(traceEntry.getTimestamp(), ZoneId.systemDefault()).toString()).put((Object)"channelName", (Object)traceEntry.getChannelName()).put((Object)"endpointType", (Object)traceEntry.getEndpointType().name()).put((Object)"key", (Object)this.prettyPrint(traceEntry.getMessage().getKey())).put((Object)"header", (Object)this.prettyPrint(traceEntry.getMessage().getHeader())).put((Object)"payload", (Object)this.prettyPrint((String)traceEntry.getMessage().getPayload())).build()).collect(Collectors.toList())));
    }

    private String prettyPrint(String json) {
        try {
            Object jsonObject = ObjectMappers.currentObjectMapper().readValue(json, Object.class);
            if (jsonObject != null) {
                return ObjectMappers.currentObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
            }
            return "null";
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String prettyPrint(Key key) {
        try {
            if (key.compactionKey().equals(key.partitionKey())) {
                return key.partitionKey();
            }
            LinkedHashMap map = Maps.newLinkedHashMap();
            map.put("partitionKey", key.partitionKey());
            map.put("compactionKey", key.compactionKey());
            return ObjectMappers.currentObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private String prettyPrint(Header header) {
        try {
            LinkedHashMap map = Maps.newLinkedHashMap();
            map.put("shardPosition", header.getShardPosition().map(ShardPosition::toString).orElse(""));
            map.put("attributes", header.getAll());
            return ObjectMappers.currentObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

