/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.state;

import com.damnhandy.uri.template.UriTemplate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.otto.edison.hal.Link;
import de.otto.edison.hal.Links;
import de.otto.edison.hal.paging.NumberedPaging;
import de.otto.edison.hal.paging.PagingRel;
import de.otto.edison.navigation.NavBar;
import de.otto.edison.navigation.NavBarItem;
import de.otto.synapse.edison.state.EdisonStateRepositoryUiProperties;
import de.otto.synapse.edison.state.PagerModel;
import de.otto.synapse.journal.JournalRegistry;
import de.otto.synapse.state.StateRepository;
import de.otto.synapse.translator.JsonHelper;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@ConditionalOnBean(value={StateRepository.class})
@ConditionalOnProperty(prefix="synapse.edison.state.ui", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class StateRepositoryUiController {
    private final JournalRegistry journals;
    private final ImmutableMap<String, StateRepository<?>> stateRepositories;
    private final String managementBasePath;

    public StateRepositoryUiController(List<StateRepository<?>> stateRepositories, JournalRegistry journals, NavBar rightNavBar, EdisonStateRepositoryUiProperties properties, @Value(value="${edison.application.management.base-path:internal}") String managementBasePath) {
        this.stateRepositories = Maps.uniqueIndex((Iterable)stateRepositories.stream().filter(repo -> !properties.getExcluded().contains(repo.getName())).collect(Collectors.toSet()), StateRepository::getName);
        this.journals = journals;
        this.managementBasePath = managementBasePath;
        this.stateRepositories.forEach((repositoryName, _repository) -> rightNavBar.register(NavBarItem.navBarItem((int)15, (String)("StateRepository: " + repositoryName), (String)String.format("/%s/staterepositories/%s", managementBasePath, repositoryName))));
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/staterepositories/{repositoryName}"}, produces={"text/html"})
    public ModelAndView getStateRepositoryHtml(@PathVariable String repositoryName, @RequestParam(defaultValue="0") int page, @RequestParam(defaultValue="100") int pageSize, UriComponentsBuilder uriComponentsBuilder) {
        if (this.stateRepositories.containsKey((Object)repositoryName)) {
            StateRepository stateRepository = (StateRepository)this.stateRepositories.get((Object)repositoryName);
            Set allEntityIds = stateRepository.keySet();
            List entityPageIds = allEntityIds.stream().skip(page * pageSize).limit(pageSize).collect(Collectors.toList());
            UriComponentsBuilder baseUriBuilder = uriComponentsBuilder.pathSegment(new String[]{this.managementBasePath}).path("/staterepositories");
            UriTemplate repositoryUri = UriTemplate.fromTemplate((String)(baseUriBuilder.toUriString() + "/" + repositoryName + "{?page,pageSize}"));
            PagerModel pagerModel = this.toPagerModel(pageSize > 0 ? NumberedPaging.zeroBasedNumberedPaging((int)page, (int)pageSize, (int)allEntityIds.size()).links(repositoryUri, EnumSet.allOf(PagingRel.class)) : Links.emptyLinks());
            List entitiesModel = entityPageIds.stream().map(entityId -> this.toEntityModel((String)entityId, stateRepository.get(entityId))).collect(Collectors.toList());
            return new ModelAndView("staterepository", (Map)ImmutableMap.builder().put((Object)"basePath", (Object)this.managementBasePath).put((Object)"singleEntity", (Object)false).put((Object)"journaled", (Object)this.journals.hasJournal(repositoryName)).put((Object)"repositoryName", (Object)repositoryName).put((Object)"entities", entitiesModel).put((Object)"pager", (Object)pagerModel).build());
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No such StateRepository " + repositoryName);
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/staterepositories/{repositoryName}"}, params={"entityId"}, produces={"text/html"})
    public View getEntityHtmlRedirect(@PathVariable String repositoryName, @RequestParam String entityId) {
        String redirectUrl = "/" + this.managementBasePath + "/staterepositories/" + repositoryName + "/" + entityId;
        return new RedirectView(redirectUrl, true);
    }

    @GetMapping(path={"${edison.application.management.base-path:internal}/staterepositories/{repositoryName}/{entityId}"}, produces={"text/html"})
    public ModelAndView getEntityHtml(@PathVariable String repositoryName, @PathVariable String entityId) {
        StateRepository stateRepository = (StateRepository)this.stateRepositories.get((Object)repositoryName);
        if (stateRepository != null && stateRepository.get(entityId).isPresent()) {
            return new ModelAndView("staterepository", (Map)ImmutableMap.builder().put((Object)"basePath", (Object)this.managementBasePath).put((Object)"singleEntity", (Object)true).put((Object)"journaled", (Object)this.journals.hasJournal(repositoryName)).put((Object)"repositoryName", (Object)repositoryName).put((Object)"entities", Collections.singletonList(this.toEntityModel(entityId, stateRepository.get(entityId).get()))).put((Object)"pager", (Object)PagerModel.UNAVAILABLE).build());
        }
        throw new ResponseStatusException(HttpStatus.NOT_FOUND, "No such StateRepository " + repositoryName);
    }

    private ImmutableMap<String, String> toEntityModel(String entityId, Object entity) {
        return ImmutableMap.of((Object)"entityId", (Object)entityId, (Object)"entityJson", (Object)JsonHelper.prettyPrint((Object)entity));
    }

    private PagerModel toPagerModel(Links pagingLinks) {
        return new PagerModel(pagingLinks.getLinkBy("self").map(Link::getHref).orElse(""), pagingLinks.getLinkBy("first").map(Link::getHref).orElse(null), pagingLinks.getLinkBy("prev").map(Link::getHref).orElse(null), pagingLinks.getLinkBy("next").map(Link::getHref).orElse(null), pagingLinks.getLinkBy("last").map(Link::getHref).orElse(null));
    }
}

