/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.statusdetail;

import de.otto.edison.status.domain.Status;
import de.otto.edison.status.domain.StatusDetail;
import de.otto.edison.status.indicator.StatusDetailIndicator;
import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.SnapshotReaderNotification;
import de.otto.synapse.info.SnapshotReaderStatus;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SnapshotStatusDetailIndicator
implements StatusDetailIndicator {
    private final Map<String, StatusDetail> statusDetails;

    @Autowired
    public SnapshotStatusDetailIndicator(Optional<List<EventSource>> eventSources) {
        this.statusDetails = eventSources.orElse(Collections.emptyList()).stream().map(EventSource::getChannelName).map(channelName -> StatusDetail.statusDetail((String)channelName, (Status)Status.OK, (String)"No snapshot info available.")).collect(Collectors.toConcurrentMap(StatusDetail::getName, Function.identity()));
    }

    @EventListener
    public void on(SnapshotReaderNotification notification) {
        String channelName = notification.getChannelName();
        if (notification.getStatus() == SnapshotReaderStatus.FAILED) {
            this.statusDetails.put(channelName, StatusDetail.statusDetail((String)channelName, (Status)Status.ERROR, (String)notification.getMessage()));
        } else {
            this.statusDetails.put(channelName, StatusDetail.statusDetail((String)channelName, (Status)Status.OK, (String)notification.getMessage()));
        }
    }

    public List<StatusDetail> statusDetails() {
        return this.statusDetails.values().stream().sorted(Comparator.comparing(StatusDetail::getName)).collect(Collectors.toList());
    }
}

