/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.history;

import de.otto.synapse.edison.history.Diff;
import de.otto.synapse.message.DefaultHeaderAttr;
import de.otto.synapse.message.Message;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class HistoryEntry {
    private final String messageKey;
    private final Object messagePayload;
    private final Instant senderTimestamp;
    private final Instant receiverTimestamp;
    private final String channelName;
    private final List<Diff> diffs;

    public HistoryEntry(Message<?> message, String channelName, List<Diff> diffs) {
        this.messageKey = message.getKey().partitionKey();
        this.messagePayload = message.getPayload();
        this.senderTimestamp = message.getHeader().getAsInstant(DefaultHeaderAttr.MSG_SENDER_TS.key());
        this.receiverTimestamp = message.getHeader().getAsInstant(DefaultHeaderAttr.MSG_RECEIVER_TS.key());
        this.channelName = channelName;
        this.diffs = diffs;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Object getMessagePayload() {
        return this.messagePayload;
    }

    public Instant getSenderTimestamp() {
        return this.senderTimestamp;
    }

    public Instant getReceiverTimestamp() {
        return this.receiverTimestamp;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public List<Diff> getDiffs() {
        return this.diffs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryEntry that = (HistoryEntry)o;
        return Objects.equals(this.messageKey, that.messageKey) && Objects.equals(this.messagePayload, that.messagePayload) && Objects.equals(this.senderTimestamp, that.senderTimestamp) && Objects.equals(this.receiverTimestamp, that.receiverTimestamp) && Objects.equals(this.channelName, that.channelName) && Objects.equals(this.diffs, that.diffs);
    }

    public int hashCode() {
        return Objects.hash(this.messageKey, this.messagePayload, this.senderTimestamp, this.receiverTimestamp, this.channelName, this.diffs);
    }

    public String toString() {
        return "HistoryEntry{messageKey='" + this.messageKey + '\'' + ", messagePayload=" + this.messagePayload + ", senderTimestamp=" + this.senderTimestamp + ", receiverTimestamp=" + this.receiverTimestamp + ", channelName='" + this.channelName + '\'' + ", diffs=" + this.diffs + '}';
    }
}

