/*
 * Decompiled with CFR 0.152.
 */
package de.otto.synapse.edison.health;

import de.otto.synapse.eventsource.EventSource;
import de.otto.synapse.info.MessageReceiverNotification;
import de.otto.synapse.info.MessageReceiverStatus;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="synapse.edison.health", name={"startup.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={EventSource.class})
public class StartupHealthIndicator
implements HealthIndicator {
    public static final long TEN_SECONDS = 10000L;
    private Set<String> allChannels;
    private Set<String> healthyChannels;

    @Autowired
    public StartupHealthIndicator(Optional<List<EventSource>> eventSources) {
        this.allChannels = eventSources.orElse(Collections.emptyList()).stream().map(EventSource::getChannelName).collect(Collectors.toSet());
        this.healthyChannels = ConcurrentHashMap.newKeySet();
    }

    @EventListener
    public void on(MessageReceiverNotification notification) {
        if (notification.getStatus() == MessageReceiverStatus.RUNNING) {
            notification.getChannelDurationBehind().ifPresent(channelDurationBehind -> {
                if (channelDurationBehind.getDurationBehind().toMillis() <= 10000L) {
                    this.healthyChannels.add(notification.getChannelName());
                }
            });
        }
    }

    public Health health() {
        Health.Builder healthBuilder = this.healthyChannels.containsAll(this.allChannels) ? Health.up().withDetail("message", (Object)"All channels up to date") : Health.down().withDetail("message", (Object)"Channel(s) not yet up to date");
        return healthBuilder.build();
    }
}

